<?php
/**
 * Template Name: activation_page
 *
 * هذا هو قالب صفحة تفعيل الحساب.
 */

// =================================================================
// الجزء الأول: معالجة البيانات (PHP Logic)
// =================================================================

// الوصول إلى المتغيرات والكائنات الأساسية
global $wpdb;
$user_id = get_current_user_id();
$table_name = $wpdb->prefix . 'user_activation';
$error_message = '';
$success_message = '';

// التحقق من أن المستخدم مسجل دخوله، وإلا لا تعرض له شيئاً
if ( ! is_user_logged_in() ) {
    wp_redirect( home_url() );
    exit;
}

// --- معالجة طلب تأكيد الكود ---
if ( isset( $_POST['submit_activation_code'] ) && isset( $_POST['activation_code'] ) ) {
    
    // 1. الحصول على الكود الذي أدخله المستخدم وتأمينه
    $user_code = sanitize_text_field( $_POST['activation_code'] );

    // 2. الحصول على الكود الصحيح من قاعدة البيانات
    $correct_code = $wpdb->get_var( $wpdb->prepare(
        "SELECT activation_code FROM $table_name WHERE user_id = %d ORDER BY created_at DESC LIMIT 1",
        $user_id
    ) );

    // 3. مقارنة الأكواد
    if ( $user_code === $correct_code ) {
        // الكود صحيح
        // تحديث الحالة في قاعدة البيانات
        $wpdb->update(
            $table_name,
            array( 'activation_status' => 1 ), // القيمة الجديدة
            array( 'user_id' => $user_id )     // شرط التحديث
        );
        
        // إعادة توجيه المستخدم إلى الصفحة الرئيسية بعد التفعيل الناجح
        wp_redirect( home_url( '/?activated=true' ) );
        exit;

    } else {
        // الكود خاطئ
        $error_message = __("<!--:en-->The code you entered is incorrect. Please try again.<!--:--><!--:ar-->الكود الذي أدخلته غير صحيح. يرجى المحاولة مرة أخرى.<!--:-->");
    }
}

// --- معالجة طلب إعادة إرسال الكود ---
if ( isset( $_POST['resend_activation_code'] ) ) {
    
    // (هذا الكود مأخوذ ومعدل من المرحلة الثانية)
    $user = get_userdata( $user_id );
    if ( $user ) {
        // 1. إنشاء كود جديد وتحديثه في قاعدة البيانات
        $new_code = random_int( 100000, 999999 );
        $wpdb->update(
            $table_name,
            array(
                'activation_code' => $new_code,
                'created_at'      => current_time( 'mysql' ),
            ),
            array( 'user_id' => $user_id )
        );

        // 2. إرسال الكود الجديد عبر البريد
        $site_name = get_bloginfo('name');
        $subject = 'كود تفعيل حسابك الجديد في ' . $site_name;
        $message = "<p>مرحباً " . $user->display_name . ",</p>";
        $message .= "<p>بناءً على طلبك، هذا هو كود التفعيل الجديد الخاص بك:</p>";
        $message .= "<p style='font-size: 24px; font-weight: bold; letter-spacing: 5px; text-align: center;'>" . $new_code . "</p>";
        $headers = array('Content-Type: text/html; charset=UTF-8');
        wp_mail( $user->user_email, $subject, $message, $headers );

        $success_message = 'تم إرسال كود تفعيل جديد إلى بريدك الإلكتروني.';
    }
}


// =================================================================
// الجزء الثاني: عرض الصفحة (HTML Layout)
// =================================================================

get_header(); // جلب الهيدر الخاص بقالبك
?>

<div id="primary" class="content-area mt-5">
   <div class="container">
        <main id="main" class="site-main" role="main">
        <article class="page type-page">
            <header class="entry-header">
                <h1 class="entry-title"><?php the_title() ?></h1>
            </header>

            <div class="entry-content">
                <p> 
                 <?php _e("<!--:en--> An activation code has been sent to your email address. Please enter the code below to activate your account and gain full access to the site.<!--:--><!--:ar--> لقد تم إرسال كود تفعيل إلى بريدك الإلكتروني. يرجى إدخال الكود أدناه لتفعيل حسابك والوصول الكامل للموقع. <!--:-->"); ?>
                </p>

                <?php if ( ! empty( $error_message ) ) : ?>
                    <div style="color: red; border: 1px solid red; padding: 10px; margin-bottom: 15px;">
                        <?php echo $error_message; ?>
                    </div>
                <?php endif; ?>

                <?php if ( ! empty( $success_message ) ) : ?>
                    <div style="color: green; border: 1px solid green; padding: 10px; margin-bottom: 15px;">
                        <?php echo $success_message; ?>
                    </div>
                <?php endif; ?>

                <!-- نموذج تأكيد الكود -->
                <form method="post" action="">
                    <div class="form-group">
                        <label for="activation_code"><?php _e("<!--:en--> Enter the activation code <!--:--><!--:ar--> أدخل كود التفعيل <!--:-->"); ?></label>
                        <input type="text" id="activation_code" name="activation_code" class="form-control" required>
                    </div>
                    <button type="submit" name="submit_activation_code" class="btn btn-primary"><?php _e("<!--:en--> to be sure <!--:--><!--:ar--> تأكيد <!--:-->"); ?></button>
                </form>

                <hr style="margin: 20px 0;">

                <!-- نموذج إعادة إرسال الكود -->
                <form method="post" action="">
                    <p>لم تستلم الكود؟</p>
                    <button type="submit" name="resend_activation_code" class="btn btn-secondary"><?php _e("<!--:en--> Resend code <!--:--><!--:ar--> إعادة إرسال الكود <!--:-->"); ?></button>
                </form>
            </div>
        </article>
    </main>
   </div>
</div>

<?php
get_footer(); // جلب الفوتر الخاص بقالبك
?>
